package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.EntidadGestoraColaboradora;
import com.ejie.ab04b.service.EntidadGestoraColaboradoraService;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0478s00Controller generated by UDA, 25-may-2017 16:56:32.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/entidadgestoracolaboradora")
public class EntidadGestoraColaboradoraController {

	private static final Logger logger = LoggerFactory
			.getLogger(EntidadGestoraColaboradoraController.class);

	@Autowired()
	private EntidadGestoraColaboradoraService entidadGestoraColaboradoraService;
	@Autowired()
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 *  codentiat078
	 *            String
	 *
	 * @param codentiat078 the codentiat 078
	 *  Ab0478s00 Objeto correspondiente al identificador indicado.
	 * @return the entidad gestora colaboradora
	 */
	@RequestMapping(value = "/{codentiat078}", method = RequestMethod.GET)
	public @ResponseBody EntidadGestoraColaboradora get(
			@PathVariable String codentiat078) {
		EntidadGestoraColaboradora entidadGestoraColaboradora = new EntidadGestoraColaboradora();
		entidadGestoraColaboradora.setCodentiat078(codentiat078);
		entidadGestoraColaboradora = this.entidadGestoraColaboradoraService
				.find(entidadGestoraColaboradora);
		EntidadGestoraColaboradoraController.logger
				.info("[GET - findBy_PK] : Obtener Ab0478s00 por PK");
		return entidadGestoraColaboradora;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 *  filterEntidadGestoraColaboradora the filter entidad gestora colaboradora
	 *
	 * @param filterEntidadGestoraColaboradora the filter entidad gestora colaboradora
	 *  List<Ab0478s00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<EntidadGestoraColaboradora> getAll(
			@ModelAttribute EntidadGestoraColaboradora filterEntidadGestoraColaboradora) {
		EntidadGestoraColaboradoraController.logger.info(
				"[GET - find_ALL] : Obtener EntidadGestoraColaboradora por filtro");
		return this.entidadGestoraColaboradoraService
				.findAll(filterEntidadGestoraColaboradora, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 *  entidadGestoraColaboradora the entidad gestora colaboradora
	 *
	 * @param entidadGestoraColaboradora the entidad gestora colaboradora
	 *  Ab0478s00 Bean resultante de la modificacion.
	 * @return the entidad gestora colaboradora
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody EntidadGestoraColaboradora edit(
			@RequestBody EntidadGestoraColaboradora entidadGestoraColaboradora) {
		EntidadGestoraColaboradora entidadGestoraColaboradoraAux = this.entidadGestoraColaboradoraService
				.update(entidadGestoraColaboradora);
		EntidadGestoraColaboradoraController.logger.info(
				"[PUT] : EntidadGestoraColaboradora actualizado correctamente");
		return entidadGestoraColaboradoraAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 *  entidadGestoraColaboradora the entidad gestora colaboradora
	 *
	 * @param entidadGestoraColaboradora the entidad gestora colaboradora
	 *  Ab0478s00 Bean resultante del proceso de creacion.
	 * @return the entidad gestora colaboradora
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody EntidadGestoraColaboradora add(
			@RequestBody EntidadGestoraColaboradora entidadGestoraColaboradora) {
		EntidadGestoraColaboradora entidadGestoraColaboradoraAux = this.entidadGestoraColaboradoraService
				.add(entidadGestoraColaboradora);
		EntidadGestoraColaboradoraController.logger.info(
				"[POST] : EntidadGestoraColaboradora insertado correctamente");
		return entidadGestoraColaboradoraAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 *  codentiat078
	 *            String Identificador del objeto que se desea eliminar.
	 *
	 * @param codentiat078 the codentiat 078
	 *  Ab0478s00 Bean eliminado.
	 * @return the entidad gestora colaboradora
	 */
	@RequestMapping(value = "/{codentiat078}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody EntidadGestoraColaboradora remove(
			@PathVariable String codentiat078) {
		EntidadGestoraColaboradora entidadGestoraColaboradora = new EntidadGestoraColaboradora();
		entidadGestoraColaboradora.setCodentiat078(codentiat078);
		this.entidadGestoraColaboradoraService
				.remove(entidadGestoraColaboradora);
		EntidadGestoraColaboradoraController.logger.info(
				"[DELETE] : EntidadGestoraColaboradora borrado correctamente");
		return entidadGestoraColaboradora;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		EntidadGestoraColaboradoraController.logger
				.info("[GET - View] : EntidadGestoraColaboradora");
		return "entidadgestoracolaboradora";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterEntidadGestoraColaboradora the filter entidad gestora colaboradora
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterEntidadGestoraColaboradora the filter entidad gestora colaboradora
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<Ab0478s00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<EntidadGestoraColaboradora> filter(
			@RequestJsonBody(param = "filter") EntidadGestoraColaboradora filterEntidadGestoraColaboradora,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		EntidadGestoraColaboradoraController.logger
				.info("[POST - filter] : Obtener EntidadGestoraColaboradora");
		return this.entidadGestoraColaboradoraService.filter(
				filterEntidadGestoraColaboradora, jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 *  filterEntidadGestoraColaboradora the filter entidad gestora colaboradora
	 *  searchEntidadGestoraColaboradora the search entidad gestora colaboradora
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 *
	 * @param filterEntidadGestoraColaboradora the filter entidad gestora colaboradora
	 * @param searchEntidadGestoraColaboradora the search entidad gestora colaboradora
	 * @param jqGridRequestDto the jq grid request dto
	 *  TableRowDto<Ab0478s00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<EntidadGestoraColaboradora>> search(
			@RequestJsonBody(param = "filter") EntidadGestoraColaboradora filterEntidadGestoraColaboradora,
			@RequestJsonBody(param = "search") EntidadGestoraColaboradora searchEntidadGestoraColaboradora,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		EntidadGestoraColaboradoraController.logger
				.info("[POST - search] : Buscar EntidadGestoraColaboradora");
		return this.entidadGestoraColaboradoraService.search(
				filterEntidadGestoraColaboradora,
				searchEntidadGestoraColaboradora, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 *  filterEntidadGestoraColaboradora the filter entidad gestora colaboradora
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterEntidadGestoraColaboradora the filter entidad gestora colaboradora
	 * @param jqGridRequestDto the jq grid request dto
	 *  List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") EntidadGestoraColaboradora filterEntidadGestoraColaboradora,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		EntidadGestoraColaboradoraController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples EntidadGestoraColaboradora");
		this.entidadGestoraColaboradoraService.removeMultiple(
				filterEntidadGestoraColaboradora, jqGridRequestDto, false);
		EntidadGestoraColaboradoraController.logger
				.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/**
	 * Realiza la exportaciÃ³n a Excel.
	 * 
	 *  filterEntidadGestoraColaboradora            Expediente Bean que contiene los parÃ¡metros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto            JQGridRequestDto que contiene los parÃ¡mtros de configuraciÃ³n
	 *            propios del RUP_TABLE a aplicar en el filtrado.
	 *  modelMap            ModelMap
	 *  columns            String
	 *  request            HttpServletRequest
	 *
	 * @param filterEntidadGestoraColaboradora the filter entidad gestora colaboradora
	 * @param jqGridRequestDto the jq grid request dto
	 * @param modelMap the model map
	 * @param columns the columns
	 * @param request the request
	 *  ModelAndView
	 * @return the report
	 */
	@RequestMapping(value = { "xlsReport",
			"xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getReport(
			@ModelAttribute() EntidadGestoraColaboradora filterEntidadGestoraColaboradora,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		// Limpiamos los datos de paginacion para mostrar todos los registros
		jqGridRequestDto.setPage(null);
		jqGridRequestDto.setRows(null);

		// Acceso a BD para recuperar datos
		List<EntidadGestoraColaboradora> listEntidadGestoraColaboradora = this.entidadGestoraColaboradoraService
				.findAllLike(filterEntidadGestoraColaboradora, jqGridRequestDto,
						false);

		// GENERAMOS EL FICHERO
		UtilidadesWar.generateReport(modelMap,
				Utilities.getLiteralMessage(this.messageSource,
						"excel.titulo.entidadGestoraColaboradora"),
				columns, listEntidadGestoraColaboradora);

		// GeneraciÃ³n del XLS o XLSX
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
	}
}
